package cn.com.duiba.activity.common.center.api.remoteservice.sharecode;

import cn.com.duiba.activity.common.center.api.dto.sharecode.InviteRuleSetDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.github.pagehelper.PageInfo;

/**
 * @author zhangruofan
 * @date 2018/04/09
 */
@AdvancedFeignClient
public interface RemoteBackendInviteRuleSetService {
    /**
     * 保存规则集
     * @param inviteRuleSetDto 规则集参数
     * @return Long id
     * @throws BizException bizException
     */
    Long insert(InviteRuleSetDto inviteRuleSetDto) throws BizException;

    /**
     * 删除规则集
     * @param id id
     * @return 1为操作成功
     * @throws BizException bizException
     */
    Integer delete(Long id) throws BizException;

    /**
     * 分页获取规则集列表
     * @param pageNo 页码
     * @param pageSize 页面大小
     * @return PageInfo<InviteRuleSetDto>
     */
    PageInfo<InviteRuleSetDto> list(Integer pageNo, Integer pageSize);
}
