package cn.com.duiba.activity.common.center.api.msg.consumeraccount;

import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;

/**
 * COMMON_CONSUMER模式提现结果通知  来自上游
 * Created by hww on 2018/9/19 下午8:54.
 */
public class CashDrawCommonResultMsg implements Serializable {

    private static final long serialVersionUID = 6938364666152555884L;

    /** 提现记录id */
    private Long recordId;
    /** 提现结果 是否成功 */
    private Boolean success = Boolean.TRUE;
    /** 如果提现失败 会把错误信息更新进订单中 */
    private String errorMsg;

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static CashDrawCommonResultMsg decode(byte[] msg) {
        String string = GZIPUtils.ungzip(msg);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, CashDrawCommonResultMsg.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param msg
     * @return
     */
    public static byte[] encode(CashDrawCommonResultMsg msg) {
        String string = JSONObject.toJSONString(msg);
        return GZIPUtils.gzip(string);
    }
}
