package cn.com.duiba.activity.common.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 邀请码的活动类型枚举
 * Created by sty on 2/2/18.
 */

public enum ShareCodeActivityTypeEnum {

    HDTOOL("hdtool"),
	CUSTOM("custom"),//定制需求
    SINGFORNEW("signForNew"),
    /**
     * 日历签到
     */
    SIGN_CALENDAR("signcalend"),
    NANCHANG("nanchang"),

    /**
     * 积分农场活动
     */
    CREDITS_FARM("farm");

    private static Map<String, ShareCodeActivityTypeEnum> typeEnumMap = Maps.newHashMap();

    static {
        for (ShareCodeActivityTypeEnum typeEnum : ShareCodeActivityTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    /**
     * 通过code获取签到类型
     *
     * @param code
     * @return
     */
    public static ShareCodeActivityTypeEnum getByCode(String code) {
        ShareCodeActivityTypeEnum type = typeEnumMap.get(code);
        if(type == null){
            return null;
        }
        return type;
    }

    private String code;

    ShareCodeActivityTypeEnum(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }
}
