package cn.com.duiba.activity.common.center.api.remoteservice.lotteryrank;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.api.bo.LotteryRankDto;
import cn.com.duiba.api.enums.LotteryRankBizTypeEnum;

import java.util.List;

@AdvancedFeignClient
public interface RemoteLotteryRankService {

    /**
     * 查询活动前rankNumber名
     * @param bizId
     * @param lotteryRankBizTypeEnum
     * @param rankNumber
     * @return
     */
    List<LotteryRankDto> findLotteryRankListApi(Long bizId, LotteryRankBizTypeEnum lotteryRankBizTypeEnum, Integer rankNumber) throws BizException;

    /**
     * 查询某个活动中用户的累计奖励
     * @param bizId
     * @param lotteryRankBizTypeEnum
     * @param consumerId
     * @return
     */
    LotteryRankDto getRankByConsumerIdApi(Long bizId,LotteryRankBizTypeEnum lotteryRankBizTypeEnum,Long consumerId) throws BizException;

    /**
     * 批量增加用户累计奖励和获胜场次
     * @param rankDtoList
     */
    void batchAddCreditsAndWinTimesApi(List<LotteryRankDto> rankDtoList);
}
