package cn.com.duiba.activity.common.center.api.remoteservice.sharecode;

import cn.com.duiba.activity.common.center.api.dto.sharecode.InviteBonusRecordDto;
import cn.com.duiba.activity.common.center.api.dto.sharecode.ShareCodeInviteBonusDto;
import cn.com.duiba.activity.common.center.api.params.sharecode.ShareCodeInviteBonusQueryParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/04/11
 */
@AdvancedFeignClient
public interface RemoteInviteBonusRecordService {
    /**
     * 新增助力奖励记录
     * @param inviteBonusRecordDto 奖励记录参数
     * @return Long bizId
     * @throws BizException bizException
     */
    Long insert(InviteBonusRecordDto inviteBonusRecordDto) throws BizException;

    /**
     * 更新奖励记录
     * @param inviteBonusRecordDto 奖励记录参数(只更新ruleType, ruleConfig, recordStatus, recordErrMsg)
     * @return count
     * @throws BizException bizException
     */
    Integer update(InviteBonusRecordDto inviteBonusRecordDto) throws BizException;

    /**
     * 获取奖励记录
     * @param bizId bizId
     * @return InviteBonusRecordDto
     * @throws BizException bizException
     */
    InviteBonusRecordDto findByBizId(Long bizId) throws BizException;

    /**
     * 查询他人帮忙集卡总数
     * @param param
     * @return
     */
    ShareCodeInviteBonusDto getInviteBonus(ShareCodeInviteBonusQueryParam param) throws BizException;

    /**
     * 分页查询记录
     */
    List<InviteBonusRecordDto> findByPage(Long consumerId, Long activityId, Integer recordStatus, Integer pageNo, Integer pageSize);
}
