package cn.com.duiba.activity.common.center.api.remoteservice.happyclear;

import cn.com.duiba.activity.common.center.api.dto.happyclear.HappyClearLevelPassPrizeDto;
import cn.com.duiba.activity.common.center.api.dto.happyclear.HappyClearRedBombDegreeDto;
import cn.com.duiba.activity.common.center.api.dto.happyclear.HappyClearRedRainSessionDto;
import cn.com.duiba.activity.common.center.api.dto.happyclear.HappyClearStarBoxLevelDto;
import cn.com.duiba.activity.common.center.api.dto.happyclear.HappyClearTaskDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/10/27 11:08
 * @description: 苏宁消消乐-活动配置
 */
@AdvancedFeignClient
public interface RemoteHappyClearBackendService {

    /**
     * 保存星星宝箱档位配置
     */
    void saveStarLevelConf(Long activityId, Long appId, List<HappyClearStarBoxLevelDto> happyClearStarBoxLevelDtoList) throws BizException;

    /**
     * 获取星星宝箱档位配置
     */
    List<HappyClearStarBoxLevelDto> selectStarLevelConf(Long activityId);

    /**
     * 保存关卡首次通关配置
     */
    void saveLevelPassConf(Long activityId, Long appId, List<HappyClearLevelPassPrizeDto> happyClearLevelPassPrizeDtoList) throws BizException;

    /**
     * 获取关卡首次通关配置
     */
    List<HappyClearLevelPassPrizeDto> selectLevelPassConf(Long activityId);

    /**
     * 保存红包雨场次配置
     */
    void saveRedRainSessionConf(Long activityId, Long appId, List<HappyClearRedRainSessionDto> redRainSessionDtoList) throws BizException;

    /**
     * 获取红包雨场次配置
     */
    List<HappyClearRedRainSessionDto> selectRedRainSessionConf(Long activityId);

    /**
     * 保存红包炸弹配置
     */
    void saveRedBombDegreeConf(Long activityId, Long appId, List<HappyClearRedBombDegreeDto> redBombDegreeDtoList) throws BizException;

    /**
     * 获取红包炸弹配置详情
     */
    List<HappyClearRedBombDegreeDto> selectRedBombDegreeConf(Long activityId);

    /**
     * saveTaskConf
     *
     * @param activityId         activityId
     * @param appId              appId
     * @param happyClearTaskDtos happyClearTaskDtos
     */
    void saveTaskConf(Long activityId, Long appId, List<HappyClearTaskDto> happyClearTaskDtos) throws BizException;

    /**
     * selectTaskConf
     *
     * @param activityId activityId
     * @return {@link List< HappyClearTaskDto>}
     */
    List<HappyClearTaskDto> selectTaskConf(Long activityId);
}
