package cn.com.duiba.activity.common.center.api.enums;

import java.util.Objects;

/**
 * @author JunAngLiu
 * @Title: StatusEnum
 * @Description: 状态枚举
 * @date 2019/3/1911:13
 */
public enum StatusEnum {

    OPEN(1,Boolean.TRUE),CLOSE(0,Boolean.FALSE);

    private Integer value;
    private Boolean status;

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public Boolean getStatus() {
        return status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    StatusEnum(Integer value, Boolean status) {
        this.value = value;
        this.status = status;
    }

    public  static  StatusEnum getByStatus(Boolean status){
        if(Objects.isNull(status)){
            return null;
        }
        if(Objects.equals(Boolean.TRUE,status)){
            return OPEN;
        }
        return CLOSE;
    }

}
