package cn.com.duiba.activity.common.center.api.enums.share;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2019/3/13.
 */
public enum ShareRewardStatusEnum {
    PROCESSING(1, "处理中"),
    SUCCESS(2, "成功"),
    FAIL(3, "失败"),
    ;
    private Integer code;
    private String desc;

    private static Map<Integer, ShareRewardStatusEnum> codeMap = new HashMap<>();
    static{
        for(ShareRewardStatusEnum type : values()){
            codeMap.put(type.getCode(), type);
        }
    }

    public static ShareRewardStatusEnum getByCode(Integer code){
        return codeMap.get(code);
    }

    ShareRewardStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
