package cn.com.duiba.activity.common.center.api.params;

import cn.com.duiba.activity.common.center.api.enums.ShareCodeActivityTypeEnum;

import java.io.Serializable;

/**
 * Created by sty on 2/2/18.
 */
public class UserInviteParam implements Serializable {

    private static final long serialVersionUID = -6270025806903447331L;
    /**
     * 输入邀请码的用户id（被邀请的人的用户id）
     */
    private Long inviteConsumerId;

    /**
     * 活动类型
     */
    private ShareCodeActivityTypeEnum shareCodeActivityTypeEnum;
    /**
     * 活动id
     */
    private Long activityId;

    private Long duibaActivityId;

    /**
     * 分享码
     */
    private String shareCode;
    /**
     * appId
     */
    private Long appId;

    /**
     * 是否没有奖励，如果为true则不预生成奖励记录
     */
    private Boolean noBonus;

    /**
     * 助力用户ip
     */
    private String ip;

    /**
     * 单个助力者对单个邀请者的助力限制类型，
     * 由于当前没有相关规则配置，因此由相关业务代码手动传参，默认永久一次
     * 0：每日  1：永久  LimitScopeEnum
     */
    private Integer singleLimitType;
    /**
     * 单个助力者对单个邀请者的助力限制次数
     */
    private Integer singleLimitTimes;

    /**
     * 单个ip下能够对单个邀请者助力的最多人数，默认不限制
     */
    private Integer singleIpLimitUsers;

    public Long getDuibaActivityId() {
        return duibaActivityId;
    }

    public void setDuibaActivityId(Long duibaActivityId) {
        this.duibaActivityId = duibaActivityId;
    }

    public Long getInviteConsumerId() {
        return inviteConsumerId;
    }

    public void setInviteConsumerId(Long inviteConsumerId) {
        this.inviteConsumerId = inviteConsumerId;
    }

    public ShareCodeActivityTypeEnum getShareCodeActivityTypeEnum() {
        return shareCodeActivityTypeEnum;
    }

    public void setShareCodeActivityTypeEnum(ShareCodeActivityTypeEnum shareCodeActivityTypeEnum) {
        this.shareCodeActivityTypeEnum = shareCodeActivityTypeEnum;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getShareCode() {
        return shareCode;
    }

    public void setShareCode(String shareCode) {
        this.shareCode = shareCode;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getActivityType(){
        ShareCodeActivityTypeEnum em = getShareCodeActivityTypeEnum();
        if(em==null){
            return null;
        }
        return em.getCode();
    }

    public Boolean getNoBonus() {
        return noBonus;
    }

    public void setNoBonus(Boolean noBonus) {
        this.noBonus = noBonus;
    }

    public Integer getSingleLimitType() {
        return singleLimitType;
    }

    public void setSingleLimitType(Integer singleLimitType) {
        this.singleLimitType = singleLimitType;
    }

    public Integer getSingleLimitTimes() {
        return singleLimitTimes;
    }

    public void setSingleLimitTimes(Integer singleLimitTimes) {
        this.singleLimitTimes = singleLimitTimes;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getSingleIpLimitUsers() {
        return singleIpLimitUsers;
    }

    public void setSingleIpLimitUsers(Integer singleIpLimitUsers) {
        this.singleIpLimitUsers = singleIpLimitUsers;
    }
}
