package cn.com.duiba.activity.custom.center.api.remoteservice.autohome;

import cn.com.duiba.activity.custom.center.api.dto.autohome.LuckyCharmDto;
import cn.com.duiba.activity.custom.center.api.dto.autohome.ShareMatchDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Desc 幸运符匹配操作
 * @Author xuwei
 * @Date 2018/8/6
 */
@AdvancedFeignClient
public interface RemoteLuckyCharmMatchService {
    /**
     * 保存幸运符信息
     * @param record 记录
     * @return 新记录
     */
    LuckyCharmDto saveLuckyCharm(LuckyCharmDto record);

    /**
     * 查询幸运符信息
     * @param consumerId 用户id
     * @return 幸运符信息
     */
    LuckyCharmDto findLuckyCharmByConsumerId(Long consumerId);

    /**
     * 标记幸运符已经分享
     * @param consumerId 用户id
     * @return 是否成功
     */
    Boolean markLuckyCharmShared(Long consumerId);

    /**
     * 保存匹配记录
     * @param record 记录
     * @return 新记录
     */
    ShareMatchDto saveMatchedResult(ShareMatchDto record);

    /**
     * 查询匹配记录
     * @param sharedConsumerId 分享者的用户id
     * @param matchedConsumerId 匹配者的用户id
     * @return 匹配记录
     */
    ShareMatchDto findMatchedResult(Long sharedConsumerId, Long matchedConsumerId);

    /**
     * 查询分享者的幸运符匹配记录
     * @param sharedConsumerId 分享者用户id
     * @return 匹配记录列表
     */
    List<ShareMatchDto> pageMatchedResults(Long sharedConsumerId, Integer offset, Integer pageSize);
}
