package cn.com.duiba.activity.custom.center.api.enums;

/**
 * Created by sunchangji on 2018/8/1.
 */
public enum RemoteRedisKeyFactory {

    /**
     * 定制方
     */
    RK010("每周之星"),
    RK011("个人榜单"),
    RK012("战队榜单"),
    RK013("二级行榜单"),
    RK014("一级行榜单");


    /**
     * 活动定制中心:activity-custom-center
     */
    private static final String SPACE = "ACCR";
    private static final String SEPARATOR = "_";
    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + SEPARATOR + super.toString() + SEPARATOR;
    }

    public String join(Object... args){
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }


    RemoteRedisKeyFactory(String description) {
    }

}
