package cn.com.duiba.activity.custom.center.api.remoteservice.icbc;

import cn.com.duiba.activity.custom.center.api.dto.icbc.IcbcWorkDto;
import cn.com.duiba.activity.custom.center.api.enums.AuditStatusEnum;
import cn.com.duiba.activity.custom.center.api.params.icbc.IcbcWorkParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by dugq on 2018/9/5 0005.
 */
@AdvancedFeignClient
public interface RemoteIcbcWorksService {
    /**
     * 根据用户id查询用户上传的作品列表
     * 包含未审核  和 未通过的
     * @param userId
     * @return
     */
    List<IcbcWorkDto> selectByUserId(Long userId);
    /**
     * 根据类型查询已经审核通过的作品
     * @param param
     * @return
     */
    List<IcbcWorkDto> selectPassWorkByTypeOrderByTime(IcbcWorkParam param);

    /**
     * 根据类型查询已经审核通过的作品 根据点赞量排序
     * @param param
     * @return
     */
    List<IcbcWorkDto> selectPassWorkByTypeOrderByLikeNum(IcbcWorkParam param);

    /**
     * 查询
     * @param pojo
     * @return
     */
    List<IcbcWorkDto> selectList(IcbcWorkParam pojo);

    /**
     * 根据id查询作品
     * @param id 作品id
     * @return
     */
    IcbcWorkDto selectOne(Long id);
    /**
     * 配合selectList 使用
     * 条件包括： userId 用户id auditStatus 审核状态 workType作品类型
     * @param pojo
     * @return
     */
    int selectCount(IcbcWorkParam pojo);
    /**
     * 插入作品
     * @param pojo
     * @return
     */
    int insert(IcbcWorkDto pojo);
    /**
     * 审核
     * @param id
     * @return
     */
    int audit(Long id, AuditStatusEnum auditStatus);
    /**
     * 点赞量+1
     * @param id 作品id
     * @param uerId 点赞人id
     * @return  返回点赞量 为0 表示作品不存在
     */
    int increaseLikeNum(Long id,Long uerId);
}
