package cn.com.duiba.activity.custom.center.api.remoteservice;

import cn.com.duiba.activity.custom.center.api.dto.becheery.BecheeryShopDto;
import cn.com.duiba.activity.custom.center.api.dto.becheery.GetVisitorDto;
import cn.com.duiba.activity.custom.center.api.dto.becheery.PopularitysRanksDto;
import cn.com.duiba.activity.custom.center.api.dto.becheery.VisitorDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Auther: linjianhui
 * @Date: 2018/8/28 10:23
 * @Description: 百草味中秋活动服务
 */
@AdvancedFeignClient
public interface RemoteBecheeryService {
    /**
     * 获取店铺人气排名榜单
     * @param consumerId
     * @return
     */
    List<PopularitysRanksDto> getPopularitysShop(Long consumerId);

    /**
     * 获取用户店铺人气排名
     * @param consumerId
     * @return
    */
    PopularitysRanksDto getSelfRanks(Long consumerId);

    /**
     * 获取访客列表
     * @return
     */
    List<VisitorDto> getVisitorList(GetVisitorDto getVisitorDto);

    /**
     *
     * @param consumerId 用户id
     * @param num  店铺需要加的人气值
     * @return
     */
    Boolean updateShopPopularity(Long consumerId,Long num);

    /**
     * 根据用户查询店铺信息
     * @param consumerId
     * @return
     */
    BecheeryShopDto findBecheeryShopByConsumerId(Long consumerId);

    /**
     * 插入店铺记录，返回时，生成的id会设置进去
     * @param shopDto
     * @return
     */
    BecheeryShopDto insertBecheeryShop(BecheeryShopDto shopDto);

    /**
     * 修改店铺相关信息
     * @param shopDto
     * @return
     */
    Boolean updateBecheeryShop(BecheeryShopDto shopDto);

}
