package cn.com.duiba.activity.custom.center.api.enums.atour;

import java.util.HashMap;
import java.util.Map;

/**
 * @auther: linjianhui
 * @date: 2019-01-11 11:42
 * @description:  pk结果
 */
public enum AtourBattleStatusEnum {


    /**
     * 对战胜利
     */
    VICTORY(1, "胜利"),

    /**
     * 对战失败
     */
    FAILURE(2, "失败");

    private static Map<Integer, AtourBattleStatusEnum> statusEnumMap = new HashMap<>();

    static {
        for (AtourBattleStatusEnum statusEnum : AtourBattleStatusEnum.values()) {
            statusEnumMap.put(statusEnum.getCode(), statusEnum);
        }
    }

    private Integer code;
    private String desc;

    AtourBattleStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 通过code获取pk状态
     * @param code
     * @return
     */
    public static AtourBattleStatusEnum getByCode(int code) {
        return statusEnumMap.get(code);
    }
}
