/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.custom.center.api.enums.kuwo;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;

public enum KuwoConsumerChanceSourceEnum {
    SOURCE_PLAY_SONG(1, "\u93be\ue15f\u6581\u59dd\u5c7e\u6d38"),
    SOURCE_FAVOR_SONG(2, "\u93c0\u60f0\u68cc\u59dd\u5c7e\u6d38"),
    SOURCE_SHARE(3, "\u9352\u55d5\u97e9"),
    SOURCE_SEND_SONG(4, "\u93b6\u66df\u58c4\u94d4\ufffd"),
    SOURCE_SIGN(5, "\u7edb\u60e7\u57cc"),
    SOURCE_NEW_VISIT(10, "\u93c2\u626e\u6564\u93b4\u70fd\ue6fb\u5a06\u00a4\ue196\u95c2\ufffd"),
    SOURCE_OLD_VISIT(11, "\u93c3\u0445\u6564\u93b4\u70fd\ue6fb\u5a06\u00a4\ue196\u95c2\ufffd");

    private static final int DEFAULT_ADD_TIMES = 1;
    private static final int NEW_VISIT_ADD_TIMES = 2;
    private static final int VISIT_EXPIRE_ADD_DAYS = 1;
    private static final int NOT_EXPIRE_ADD_YEARS = 10;
    private static final ZoneId DEFAULT_ZONE_ID;
    private Integer source;
    private String desc;
    private static Map<Integer, KuwoConsumerChanceSourceEnum> enumMap;

    private KuwoConsumerChanceSourceEnum(Integer source, String desc) {
        this.source = source;
        this.desc = desc;
    }

    public static KuwoConsumerChanceSourceEnum getBySource(Integer source) {
        return enumMap.get(source);
    }

    public int getAddTimes() {
        if (this == SOURCE_NEW_VISIT) {
            return 2;
        }
        return 1;
    }

    public Date getExpireTime() {
        if (this == SOURCE_NEW_VISIT || this == SOURCE_OLD_VISIT) {
            return Date.from(LocalDate.now().plusDays(1L).atStartOfDay(DEFAULT_ZONE_ID).toInstant());
        }
        return Date.from(LocalDate.now().plusYears(10L).atStartOfDay(DEFAULT_ZONE_ID).toInstant());
    }

    public Integer getSource() {
        return this.source;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        DEFAULT_ZONE_ID = ZoneId.systemDefault();
        enumMap = Maps.newHashMap();
        enumMap.put(SOURCE_PLAY_SONG.getSource(), SOURCE_PLAY_SONG);
        enumMap.put(SOURCE_FAVOR_SONG.getSource(), SOURCE_FAVOR_SONG);
        enumMap.put(SOURCE_SHARE.getSource(), SOURCE_SHARE);
        enumMap.put(SOURCE_SIGN.getSource(), SOURCE_SIGN);
    }
}

