package cn.com.duiba.activity.custom.center.api.remoteservice.yonghui;

import cn.com.duiba.activity.custom.center.api.dto.yonghui.NewUserHelpListDto;
import cn.com.duiba.activity.custom.center.api.dto.yonghui.NewUserHelpListParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 永辉新人活动
 */
@AdvancedFeignClient
public interface RemoteNewUserHelpListService {

    /**
     * 插入
     *
     * @param pojo
     * @return
     */
    Long insert(NewUserHelpListDto pojo);


    /**
     * 查询
     *
     * @param pojo
     * @return
     */
    List<NewUserHelpListDto> selectList(NewUserHelpListParam pojo);


    /**
     * 修改
     *
     * @param pojo
     * @return
     */
    Integer updateById(NewUserHelpListDto pojo);

    /**
     * 统计个数
     *
     * @param pojo
     * @return
     */
    Long count(NewUserHelpListParam pojo);

    NewUserHelpListDto findByConsumerIdAndHelpConsumerIdAndRoleTypes(Long consumerId, Long helpConsumerId, List<Integer> roleTypes);
}
