package cn.com.duiba.activity.custom.center.api.remoteservice.qqmusic;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.custom.center.api.dto.qqmusic.QQMusicAuctionIndexDto;
import cn.com.duiba.activity.custom.center.api.dto.qqmusic.QQMusicAuctionRecordDto;
import cn.com.duiba.biz.tool.duiba.dto.RequestParams;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author zhengjianhao
 * @date 2019/7/22
 * @description
 */
@AdvancedFeignClient
public interface RemoteQQMusicAuctionRecordService {

	/**
	 * 获取首页信息
	 */
	QQMusicAuctionIndexDto index(Long operatingActivityId, Date recordDate, Long consumerId) throws BizException;

	/**
	 * 获取中奖记录列表
	 */
	List<QQMusicAuctionRecordDto> getCarousel(Long operatingActivityId);

	/**
	 * 根据id获取拍卖记录
	 */
	QQMusicAuctionRecordDto getById(Long id);

	/**
	 * 获取用户拍卖记录列表
	 */
	List<QQMusicAuctionRecordDto> recordList(Long operatingActivityId, Long consumerId);

	/**
	 * 出价
	 */
	void bid(Long operatingActivityId, Long prizeId, Long bid, Long consumerId, Long appId) throws BizException;

	/**
	 * 领奖
	 */
	void takePrize(OperatingActivityDto operatingActivityDto, Long recordId, Long consumerId, RequestParams requestParams) throws BizException;
}
