package cn.com.duiba.activity.custom.center.api.remoteservice.vienna;

import cn.com.duiba.activity.custom.center.api.dto.vienna.ViennaLachineAwardDto;
import cn.com.duiba.activity.custom.center.api.dto.vienna.ViennaLachineConsumerDataDto;
import cn.com.duiba.activity.custom.center.api.dto.vienna.ViennaLachineDoJoinResultDto;
import cn.com.duiba.activity.custom.center.api.dto.vienna.ViennaLachineIndexDto;
import cn.com.duiba.activity.custom.center.api.dto.vienna.ViennaLachineInviteRecordDto;
import cn.com.duiba.activity.custom.center.api.params.vienna.LachineInviteListParam;
import cn.com.duiba.activity.custom.center.api.params.vienna.LachineInviteSuccessParam;
import cn.com.duiba.activity.custom.center.api.params.vienna.LachineNormalParam;
import cn.com.duiba.activity.custom.center.api.params.vienna.LachinePopupParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 维也纳拉新活动远程服务
 * Created by HePeng on 2019/07/22 20:29.
 */
@AdvancedFeignClient
public interface RemoteViennaLachineService {
    /**
     * 活动首页
     * @param param
     * @return
     */
    ViennaLachineIndexDto index(LachineNormalParam param);

    /**
     * 已弹窗
     * @param param
     * @throws BizException
     */
    void popup(LachinePopupParam param) throws BizException;

    /**
     * 用户活动数据
     * @param consumerId
     * @param activityId
     * @return
     */
    ViennaLachineConsumerDataDto consumerData(Long consumerId, Long activityId);

    /**
     * 抽奖
     * @param param
     * @throws BizException
     */
    ViennaLachineDoJoinResultDto doJoin(LachineNormalParam param) throws BizException;

    /**
     * 邀请成功
     * @param param
     * @throws BizException
     */
    void inviteSuccess(LachineInviteSuccessParam param) throws BizException;

    /**
     * 我的奖品页数据
     * @param param
     * @return
     */
    ViennaLachineAwardDto awardData(LachineNormalParam param);

    /**
     * 邀请列表
     * @param param
     * @return
     */
    List<ViennaLachineInviteRecordDto> inviteList(LachineInviteListParam param);

}
