package cn.com.duiba.activity.custom.center.api.dto.qqmusic;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zhengjianhao
 * @date: 2019/7/22 16:10
 * @description: qq音乐拍卖活动-出价记录
 */
public class QQMusicAuctionRecordDto implements Serializable {

	private static final long serialVersionUID = -3775462940435621755L;

	/**
	 * 主键id
	 */
	private Long id;

	/**
	 * appid
	 */
	private Long appId;

	/**
	 * 入库活动id
	 */
	private Long operatingActivityId;

	/**
	 * 参与日期
	 */
	private Date recordDate;

	/**
	 * 当前场次开始时间
	 */
	private Date startTime;

	/**
	 * 当前场次结束时间
	 */
	private Date endTime;

	/**
	 * 奖品id
	 */
	private Long prizeId;

	/**
	 * 奖品名称
	 */
	private String prizeName;

	/**
	 * 奖品缩略图
	 */
	private String prizeImage;

	/**
	 * 用户id
	 */
	private Long consumerId;

	/**
	 * 用户uid
	 */
	private String partnerUserId;

	/**
	 * 用户昵称
	 */
	private String nickName;

	/**
	 * 用户出价
	 */
	private Long bid;

	/**
	 * 出价记录状态：0，拍卖中；1，拍失败；2，拍成功，待领奖；3、拍成功，领取中；4，拍成功，已领取
	 *
	 * @see cn.com.duiba.activity.custom.center.api.enums.qqmusic.QQMusicAuctionRecordStatusEnum
	 */
	private Integer recordStatus;

	/**
	 * 扣积分插件子订单号
	 */
	private String creditsOrderNum;

	/**
	 * 发奖主订单号
	 */
	private String prizeOrderNum;

	/**
	 * 发奖失败信息
	 */
	private String errorMessage;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getOperatingActivityId() {
		return operatingActivityId;
	}

	public void setOperatingActivityId(Long operatingActivityId) {
		this.operatingActivityId = operatingActivityId;
	}

	public Date getRecordDate() {
		return recordDate;
	}

	public void setRecordDate(Date recordDate) {
		this.recordDate = recordDate;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Long getPrizeId() {
		return prizeId;
	}

	public void setPrizeId(Long prizeId) {
		this.prizeId = prizeId;
	}

	public String getPrizeName() {
		return prizeName;
	}

	public void setPrizeName(String prizeName) {
		this.prizeName = prizeName;
	}

	public String getPrizeImage() {
		return prizeImage;
	}

	public void setPrizeImage(String prizeImage) {
		this.prizeImage = prizeImage;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public String getPartnerUserId() {
		return partnerUserId;
	}

	public void setPartnerUserId(String partnerUserId) {
		this.partnerUserId = partnerUserId;
	}

	public String getNickName() {
		return nickName;
	}

	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	public Long getBid() {
		return bid;
	}

	public void setBid(Long bid) {
		this.bid = bid;
	}

	public Integer getRecordStatus() {
		return recordStatus;
	}

	public void setRecordStatus(Integer recordStatus) {
		this.recordStatus = recordStatus;
	}

	public String getCreditsOrderNum() {
		return creditsOrderNum;
	}

	public void setCreditsOrderNum(String creditsOrderNum) {
		this.creditsOrderNum = creditsOrderNum;
	}

	public String getPrizeOrderNum() {
		return prizeOrderNum;
	}

	public void setPrizeOrderNum(String prizeOrderNum) {
		this.prizeOrderNum = prizeOrderNum;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}
}
