package cn.com.duiba.activity.custom.center.api.enums.ccb;

import java.util.HashMap;
import java.util.Map;

/**
 * 供应商枚举
 */
public enum SupplierEntityEnum {


    LIANHAI(1, "联海"),
    KAYING(2,"卡赢"),
    WEINENG(3,"微能"),
    ;

    private Integer code;

    private String desc;

    private static final Map<Integer, SupplierEntityEnum> ENUM_MAP = new HashMap<>();

    static{
        for(SupplierEntityEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    SupplierEntityEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static SupplierEntityEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
