package cn.com.duiba.activity.custom.center.api.enums.expandredpacket;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2019/4/29 11:21
 */
public enum RedpacketOptStatusEnum {

    /**
     * 操作状态：0-正常，1-提现中，2-提现成功，3-提现失败，4-失效，5-分享，6-助力
     */
    NORMAL(0,"正常"),
    DRAWING(1,"提现中"),
    DRAW_SUCCESS(2,"提现成功"),
    DRAW_FAIL(3,"提现失败"),
    EXPIRED(4,"失效"),
    SHARE(5,"分享"),
    HELP(6,"助力"),
    ;

    private Integer optStatus;

    private String desc;

    RedpacketOptStatusEnum(Integer optStatus, String desc) {
        this.optStatus = optStatus;
        this.desc = desc;
    }
    private static final Map<Integer, RedpacketOptStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(RedpacketOptStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getOptStatus(), tmp);
        }
    }

    public static RedpacketOptStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public Integer getOptStatus() {
        return optStatus;
    }

    public String getDesc() {
        return desc;
    }
}
