package cn.com.duiba.activity.custom.center.api.remoteservice.expandredpacket;

import cn.com.duiba.activity.custom.center.api.dto.expandredpacket.CashDrawRankDto;
import cn.com.duiba.activity.custom.center.api.dto.expandredpacket.RedpacketOptRecordDto;
import cn.com.duiba.activity.custom.center.api.enums.expandredpacket.RedpacketOptStatusEnum;
import cn.com.duiba.activity.custom.center.api.params.expandredpacket.RedpacketOptRecordQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author chengsiyi
 * @date 2019/4/29 14:35
 */
@AdvancedFeignClient
public interface RemoteRedpacketOptRecordService {

    Long insert(RedpacketOptRecordDto dto);

    /**
     * 更新日志操作状态
     * @param optStatus 状态
     * @param id ID
     * @return 更新结果
     */
    Integer update(RedpacketOptStatusEnum optStatus, Long id);

    /**
     * 获取日志
     * @param param
     * @return
     */
    List<RedpacketOptRecordDto> getOptRecord(RedpacketOptRecordQueryParam param);

    /**
     * 获取用户短时间内助力日志
     *
     * @param consumerId 助力用户ID
     * @param limitStartTime 开始时间点
     * @return
     */
    List<RedpacketOptRecordDto> getConsumerLimitTimeHelpRecord(Long consumerId, String limitStartTime);

    /**
     * 获取用户时间段内提现总额
     * @param consumerId
     * @param start
     * @param end
     * @param activityId
     * @return
     */
    Long getCashDrawAmount(Long consumerId, Date start, Date end, Long activityId);

    Long getCashDrawTotalAmount(Long appId, Date start, Date end, Long activityId);

    /**
     * 获取提现排名
     * @param appId
     * @param activityId
     * @return
     */
    List<CashDrawRankDto>  getCashDrawRank(Long appId, Long activityId);
}
