package cn.com.duiba.activity.custom.center.api.remoteservice.happyclear;

import cn.com.duiba.activity.custom.center.api.dto.happyclear.HappyClearRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2019/8/13 11:56
 */
@AdvancedFeignClient
public interface RemoteHappyClearRecordService {

    /**
     * 保存用户关卡信息
     * @param dto 关卡信息
     * @return 编号
     */
    Long save(HappyClearRecordDto dto);

    /**
     * 根据 activityId，consumerId，levelNum更新
     * 更新用户关卡信息(levelNum,maxScore,stars)
     * @param dto 关卡信息
     * @return 更新结果
     */
    Integer updateLevel(HappyClearRecordDto dto);

    /**
     * 获取用户关卡信息
     * @param activityId 入库ID
     * @param consumerId 用户ID
     * @param levelNum 关卡
     * @return 数据
     */
    List<HappyClearRecordDto> getConsumerRecords(Long activityId, Long consumerId, Integer levelNum);
}
