package cn.com.duiba.activity.custom.center.api.enums.happyclear;

/**
 * @Description: 苏宁消消乐-发奖请求，业务类型
 * @Author: fxr
 * @Date: 2019/10/23
 */
public enum HappyClearAwardBizTypeEnum {
    FIRST_CROSS_AWARD(1, "首闯奖励"),
    TREASURE_BOX_AWARD(2, "宝箱奖励"),
    SIGN_AWARD(3, "签到奖励"),
    INVITE_AWARD(4, "邀请有礼奖励"),
    BIG_WHEEL_AWARD(5, "大转盘奖励"),
    SCRATCH_CARD_AWARD(6, "刮刮卡奖励"),
    RETURN_AWARD(7, "回归奖励"),
    VCOIN_EXCHANGE(8, "金币兑换"),
    RED_RAIN(9, "红包雨"),
    RED_BOMB(10, "红包炸弹"),
    ;

    Integer code;
    String desc;

    HappyClearAwardBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static HappyClearAwardBizTypeEnum valueOfCode(Integer code) {
        for (HappyClearAwardBizTypeEnum obj : HappyClearAwardBizTypeEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static HappyClearAwardBizTypeEnum valueOfDesc(String desc) {
        for (HappyClearAwardBizTypeEnum obj : HappyClearAwardBizTypeEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
