package cn.com.duiba.activity.custom.center.api.remoteservice.ccb;

import cn.com.duiba.activity.custom.center.api.dto.ccb.CcbSupplierRetryOrderDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by 歪大哥😁 on 2019-11-18.
 */
@AdvancedFeignClient
public interface RemoteCcbSupplierRetryOrderService {

    /**
     * 根据供应商编码 查询对应供应商需要重试的订单
     * @param supplierType {@link cn.com.duiba.activity.custom.center.api.enums.ccb.SupplierEntityEnum}
     * @return
     */
    List<CcbSupplierRetryOrderDto> findRetryOrderBySupplierType(Integer supplierType);

    /**
     * 根据id 查询
     * @param id
     * @return
     */
    CcbSupplierRetryOrderDto findById(Long id);

    /**
     * 根据兑吧订单号 查询
     * @param orderNum
     * @return
     */
    CcbSupplierRetryOrderDto findByOrderNum(String orderNum);

    /**
     * 新增需要重试的订单
     * @param order
     * @return
     */
    Long insert(CcbSupplierRetryOrderDto order);

    /**
     * 将订单更新为已发送
     * @param id
     * @return
     */
    boolean updateStatusToSend(Long id);

    /**
     * 将订单更新为已完成
     * @param id
     * @return
     */
    boolean updateStatusToComplete(Long id, String responseInfo);

    /**
     * 将订单更新为需要再次重试
     * @param id
     * @return
     */
    boolean updateStatusToNeedRetry(Long id, String responseInfo);

    /**
     * 将订单更新为已达重试上线
     * @param id
     * @return
     */
    boolean updateStatusToRetryFinish(Long id, String responseInfo);

    /**
     * 将订单更新为已响应-卡单
     * @param id
     * @return
     */
    boolean updateStatusToResponse(Long id, String responseInfo);

}
