package cn.com.duiba.activity.custom.center.api.remoteservice.darling;

import cn.com.duiba.activity.custom.center.api.dto.darling.MilkCostRecordDto;
import cn.com.duiba.activity.custom.center.api.params.darling.MilkCostRecordQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Description: 达令家养成活动二期定制，牛奶消耗记录
 * @Author: fxr
 * @Date: 2019/10/9
 */
@AdvancedFeignClient
public interface RemoteMilkCostRecordService {
    /**
     * 保存牛奶消耗记录
     *
     * @param milkCostRecord
     */
    void save(MilkCostRecordDto milkCostRecord);

    /**
     * 根据子订单id，和类型查询牛奶消耗记录
     *
     * @param paramList
     * @return
     */
    List<MilkCostRecordDto> batchFind(List<MilkCostRecordQueryParam> paramList);
}
