package cn.com.duiba.activity.custom.center.api.remoteservice.watsons;

import cn.com.duiba.activity.custom.center.api.dto.watsons.WatsonsJoinGroupDto;
import cn.com.duiba.activity.custom.center.api.enums.watsons.WatsonsJoinGroupTypeEnum;
import cn.com.duiba.activity.custom.center.api.params.watsons.WatsonsJoinGroupSaveParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by fangdong on 2019/04/19
 */
@AdvancedFeignClient
public interface RemoteWatsonsJoinGroupService {

    /**
     * 根据id查询
     * @param id 主键
     * @return 拼团
     * @throws BizException
     */
    WatsonsJoinGroupDto getById(Long id) throws BizException;

    /**
     * 查询用户拼团
     * @param cid 用户id
     * @param type 拼团类型
     * @return 用户拼团
     * @throws BizException
     */
    WatsonsJoinGroupDto getByCidAndType(Long cid, WatsonsJoinGroupTypeEnum type) throws BizException;

    /**
     * 保存
     * @param activity 拼团
     * @return 主键
     * @throws BizException
     */
    Long save(WatsonsJoinGroupSaveParam group) throws BizException;

    /**
     * 查询用户拼团列表
     * @param cid
     * @return
     * @throws BizException
     */
    List<WatsonsJoinGroupDto> listByCid(Long cid) throws BizException;

    /**
     * 新增用户拼团列表
     * @param groups
     * @return
     * @throws BizException
     */
    List<Long> insertList(List<WatsonsJoinGroupSaveParam> groups) throws BizException;
}
