package cn.com.duiba.activity.custom.center.api.remoteservice.bonus;

import cn.com.duiba.activity.custom.center.api.dto.bonus.DeveloperBonusLogDto;
import cn.com.duiba.activity.custom.center.api.enums.NanChang.OptypeEnum;
import cn.com.duiba.activity.custom.center.api.enums.NanChang.RedPackageStatuEnum;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 该 service 适用与于开发者对接红包或者其他奖励，具体奖励由开发者发放，我方只负责调用对方接口进行通知
 *
 * @author chengsiyi
 * @date 2018/12/3 10:38
 */
@AdvancedFeignClient
public interface RemoteDeveloperBonusLogService {

    /**
     * 插入日志记录，consumerId，appId，partnerUserId，缺一不可，bonus默认0
     *
     * @param developerBonusLogDto 数据
     * @return boolean
     */
    Long insertLog(DeveloperBonusLogDto developerBonusLogDto);

    /**
     * 批量插入日志记录，consumerId，appId，partnerUserId，缺一不可，bonus默认0
     *
     * @param developerBonusLogDto 数据
     * @return boolean
     */
    Long insertLogBatch(List<DeveloperBonusLogDto> developerBonusLogDtos);

    /**
     * 根据用户ID获取红包记录，缓存时间1小时
     *
     * @param consumerId 用户ID
     * @return 红包记录
     */
    List<DeveloperBonusLogDto> getRecordByCid(Long consumerId);

    /**
     * 更新红包记录，用于通知开发者失败更新
     * @param dto
     * @return
     */
    Integer updateBonusById(DeveloperBonusLogDto dto);

    /**
     * 南昌招行
     * @param
     * @return
     */
    List<DeveloperBonusLogDto> selectByCidAppIdOptype(Long consumerId, Long appId, RedPackageStatuEnum status, List<OptypeEnum> optypeEnums) throws BizException;

    /**
     * 南昌招行，批量更新红包状态为已领取
     * @param ids
     * @return
     */
    Integer updateStatusAccpetdByIds(Long consumerId,Long appId,List<Long> ids) throws BizException;
}
