package cn.com.duiba.activity.custom.center.api.remoteservice.boc;

import cn.com.duiba.activity.custom.center.api.params.boc.UserWhiteListParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author xujing
 * @date 2020/3/12
 */
@AdvancedFeignClient
public interface RemoteUserWhiteListService {
    /**
     * 根据条件判断是否在白名单之内
     *
     * @param appId    应用id
     * @param relType  类型
     * @param relValue 值
     * @return
     */
    Boolean isInWhiteList(Long appId, Integer relType, String relValue);

    /**
     * 批量入库
     *
     * @param userWhiteListParam
     * @return
     */
    Integer batchInsert(UserWhiteListParam userWhiteListParam);


    /**
     * 批量删除
     *
     * @param userWhiteListParam
     * @return
     */
    Integer batchDelete(UserWhiteListParam userWhiteListParam);
}
