package cn.com.duiba.activity.custom.center.api.remoteservice.activity;

import cn.com.duiba.activity.custom.center.api.dto.activity.ActivityValidateDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by 刘凯 on 2019/05/20
 */
@AdvancedFeignClient
public interface RemoteActivityValidateService {

    /**
     * Desc : 获取对应验证码类型的请求key
     * @param activityId
     */
    String getCaptchId(Long activityId);



    /**
     * 用户提交表单(post-form)到产品应用后台，会携带一个验证码相关的参数，参数名为 NECaptchaValidate。
     * 产品应用需要将该参数传给易盾验证码后台做二次校验，以确保该次验证是有效并且是最近完成的。
     *
     * @param validate 提交二次校验的验证数据，即NECaptchaValidate值
     * @param userId 用户id 可以为null
     * @param activityId 活动长id
     * @return 易盾二次验证的结果
     */
    ActivityValidateDto isCaptchaPass(String validate, String userId, Long activityId);





}
