package cn.com.duiba.activity.custom.center.api.remoteservice.expandredpacket;

import cn.com.duiba.activity.custom.center.api.dto.expandredpacket.ExpandRedpacketInfoDto;
import cn.com.duiba.activity.custom.center.api.dto.expandredpacket.RedpacketOptRequest;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2019/4/29 14:31
 */
@AdvancedFeignClient
public interface RemoteExpandRedpacketInfoService {

    /**
     * 查询用户获取到的红包
     * @param appId
     * @param activityId
     * @param consumerId
     * @return
     */
    List<ExpandRedpacketInfoDto> getConsumerPacket(Long appId, Long activityId, Long consumerId);

    /**
     * 保存红包
     * @param dto
     * @return
     */
    Long insert(ExpandRedpacketInfoDto dto);

    /**
     * 更新红包金额
     * @param dto
     * @return
     */
    Long updateAmount(RedpacketOptRequest dto);

    /**
     * 更新红包信息(expireTime 和 packetStatus)
     * @param dto 红包信息
     * @return
     */
    Integer update(ExpandRedpacketInfoDto dto);
}
