package cn.com.duiba.activity.custom.center.api.remoteservice.icbc;

import cn.com.duiba.activity.custom.center.api.dto.icbc.IcbcUserToExtraDTO;
import cn.com.duiba.activity.custom.center.api.params.icbc.IcbcUserToExtraParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @InterfaceName RemoteIcbcUserToExtraService
 * @Description 工行（e生活）uid对extra关联信息接口
 * @Author zhoujunquan@hzchuangbo.com
 * @Date 2021/3/10 1:11 下午
 * @Version 1.0
 **/
@AdvancedFeignClient
public interface RemoteIcbcUserToExtraService {
    /**
     * 插入工行（e生活）uid和extra关联信息
     *
     * @param param 插入参数
     * @return 主键id
     */
    Long insert(IcbcUserToExtraParam param);

    /**
     * 根据uid查询对象
     *
     * @param uid 开发者uid
     * @return {@link IcbcUserToExtraDTO}
     */
    IcbcUserToExtraDTO getUserInfoByUid(Long uid);

    /**
     * 根据cisNo查询对应有多少用户
     *
     * @param cisNo 客编号
     * @return 用户数
     */
    int countUserByCisNo(String cisNo);

    /**
     * 根据参数查询列表
     *
     * @param param {@link IcbcUserToExtraParam}
     * @return {@link IcbcUserToExtraDTO}
     */
    List<IcbcUserToExtraDTO> listUserInfoByCisNo(IcbcUserToExtraParam param);

    /**
     * 根据id修改附加信息
     *
     * @param param {@link IcbcUserToExtraParam}
     * @return 修改影响行数
     */
    int update(IcbcUserToExtraParam param);
}