package cn.com.duiba.activity.custom.center.api.enums.watsons;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by fangdong on 2019/04/19
 */
public enum WatsonsJoinGroupStatusEnum {

    NOT_JOINED(0, "未参加"),
    JOINED(1, "已参加"),
    ;

    WatsonsJoinGroupStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static Map<Integer, WatsonsJoinGroupStatusEnum> typeEnumMap = new HashMap<>();

    static {
        for (WatsonsJoinGroupStatusEnum typeEnum : WatsonsJoinGroupStatusEnum.values()) {
            typeEnumMap.put(typeEnum.getType(), typeEnum);
        }
    }

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static WatsonsJoinGroupStatusEnum getByType(Integer type) {
        return typeEnumMap.get(type);
    }

}
