package cn.com.duiba.activity.custom.center.api.remoteservice.ccb;

import cn.com.duiba.activity.custom.center.api.dto.ccb.HelloClassmateDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by 歪大哥😁 on 2019-09-22.
 */
@AdvancedFeignClient
public interface RemoteHelloClassmateService {

    // 增加打卡记录
    Long insert(HelloClassmateDto entity);
    // 批量增加打卡记录
    void insertList(List<HelloClassmateDto> entities);
    // 根据开发者用户id 查询所有打卡记录
    List<HelloClassmateDto> findByUid(String uid);
    // 增加周末半价购次数
    Long incrSalesVolumeToday(Long count);

    // 增加用户的周末半价总参与次数
    Long incrSalesVolumeByCidTotal(Long cid, Long count);

    // 增加用户今日的半价购当日参与次数
    Long incrSalesVolumeByCidToday(Long cid, Long count);

    // 查询当前已增加的 周末半价购次数
    Long getSalesVolumeToday();

    // 查询用户的周末半价总参与次数
    Long getSalesVolumeByCidTotal(Long cid);

    // 查询用户今日的半价购参与次数
    Long getSalesVolumeByCidToday(Long cid);

    void doRollBackSalesVolume(Long cid);

}
