package cn.com.duiba.activity.custom.center.api.remoteservice.happyclear;

import cn.com.duiba.activity.custom.center.api.dto.happyclear.HappyClearTopRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 苏宁消消乐-用户最高闯关记录
 *
 * @author fxr
 * @date 2020-10-21
 */
@AdvancedFeignClient
public interface RemoteHappyClearTopRecordService {

    /**
     * 保存
     *
     * @param happyClearTopRecordDto 记录对象
     * @return {@link Long}
     */
    Long save(HappyClearTopRecordDto happyClearTopRecordDto);


    /**
     * 通过入库活动id，和用户id更新记录
     * 可选更新字段：levelNum,maxScore,stars （不为空才会被更新）
     * 更新条件必传：activityId，consumerId
     *
     * @param happyClearTopRecordDto 记录对象
     * @return {@link Integer}
     */
    Integer updateByActCid(HappyClearTopRecordDto happyClearTopRecordDto);

    /**
     * 通过入库活动id，和用户id获取用户最高闯关记录
     *
     * @param activityId 活动id
     * @param consumerId 用户id
     * @return {@link HappyClearTopRecordDto}
     */
    HappyClearTopRecordDto getByActCid(Long activityId, Long consumerId);

    /**
     * 通过活动id，和用户id集合批量查询用户最高闯关记录
     *
     * @param activityId  活动id
     * @param consumerIds 用户id
     * @return {@link List<HappyClearTopRecordDto>}
     */
    List<HappyClearTopRecordDto> findByActCids(Long activityId, List<Long> consumerIds);

    /**
     * 通过活动id，和关卡，查看最高闯关记录为本关卡的用户
     *
     * @param activityId 活动id
     * @param levelNum   关卡
     * @return {@link List<HappyClearTopRecordDto>}
     */
    List<HappyClearTopRecordDto> findByLevel(Long activityId, Integer levelNum);
}
