package cn.com.duiba.activity.custom.center.api.remoteservice.happyclear;

import cn.com.duiba.activity.custom.center.api.dto.happyclear.HappyClearHelpRecordDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/10/28 11:56
 * @description: 苏宁消消乐-刮刮卡助力记录
 */
@AdvancedFeignClient
public interface RemoteHappyHelpRecordService {

	/**
	 * 新增刮刮卡助力记录
	 */
	Long insert(HappyClearHelpRecordDto happyClearHelpRecordDto);

	/**
	 * 助力校验
	 */
	void doHelp(Long activityId, Integer bizType, Long consumerId, String shareCode) throws BizException;

	/**
	 * 根据分享码获取被助力记录
	 */
	List<HappyClearHelpRecordDto> selectHelpList(Long activityId, Integer bizType, String shareCode);
}
