package cn.com.duiba.activity.custom.center.api.remoteservice.wanda;

import cn.com.duiba.activity.custom.center.api.dto.wanda.WanDaCityDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteWanDaCityService {

    /** 查询所有城市列表 */
    List<WanDaCityDto> selectAll();

    /**
     * 模糊搜索城市 可以是拼音或汉字
     * 例如：根据bei可以搜索到北京
     * 但是根据bj，bej等无法搜索到北京
     * */
    List<WanDaCityDto> searchByCityName(String city);

    /** 根据城市名称 精确查找城市信息 */
    WanDaCityDto findByCityName(String city);

    /** 同步万达城市信息 */
    void syncAllCityFromWanDa();

}
