package cn.com.duiba.activity.custom.center.api.enums.annaier;


import java.util.HashMap;
import java.util.Map;

/**
 * 拼团状态枚举
 * liukai
 */
public enum RecordStatuEnum {

    JOINING(1,"已参团"),
    FAIL_JOIN(2,"拼团失败"),
    NO_REWARD(3,"未中奖"),
    REWARD(4,"已中奖"),
    REWARD_REVEIVED(5,"已领取"),
    ;

    private Integer code;

    private String desc;

    RecordStatuEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }


    private static final Map<Integer, RecordStatuEnum> enumMap = new HashMap<>();
    static{
        for(RecordStatuEnum recordStatuEnum : values()){
            enumMap.put(recordStatuEnum.getCode(), recordStatuEnum);
        }
    }

    public static RecordStatuEnum getByCode(Integer code) {
        RecordStatuEnum recordStatuEnum = enumMap.get(code);
        if(recordStatuEnum == null){
            return null;
        }
        return recordStatuEnum;
    }


}
