package cn.com.duiba.activity.custom.center.api.params.cebbank;

import cn.com.duiba.wolf.utils.DateUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2019/5/29 0029 10:39
 */
public class IncrementParam implements Serializable {
    private static final long serialVersionUID = -2633314694232992604L;
    /**
     * 用户ID
     */
    private Long consumerId;
    /**
     * 活动id。必传
     */
    private Long activityId;

    /**
     * 年利率，百分数，精确到万分一。
     * 1.年利率3.12% rate=312
     */
    private Long rate;

    /**
     * 最近一次收集时间
     * 1.使用默认赋值。没有提供set接口 190101格式
     */
    private String collectRecentlyDay;

    /**
     * 利息开始时间
     * 1.使用默认赋值。没有提供set接口
     */
    private Date interestOutTimeStart;

    public IncrementParam() {
        Date date = DateUtils.daysAddOrSub(new Date(), -1);
        collectRecentlyDay = String.valueOf(DateUtils.getYYDayNumber(date));
        interestOutTimeStart = DateUtils.getDayStartTime(date);
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getRate() {
        return rate;
    }

    public void setRate(Long rate) {
        this.rate = rate;
    }

    public String getCollectRecentlyDay() {
        return collectRecentlyDay;
    }

    public Date getInterestOutTimeStart() {
        return interestOutTimeStart;
    }
}
