package cn.com.duiba.activity.custom.center.api.remoteservice.happyclear;

import cn.com.duiba.activity.custom.center.api.dto.happyclear.HappyClearRecordDto;
import cn.com.duiba.activity.custom.center.api.params.happyclear.HappyClearRecordQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2019/8/13 11:56
 */
@AdvancedFeignClient
public interface RemoteHappyClearRecordService {

    /**
     * 保存用户关卡信息
     *
     * @param dto 关卡信息
     * @return {@link Long}
     */
    Long save(HappyClearRecordDto dto);

    /**
     * 根据 activityId，consumerId，levelNum更新
     * 更新用户关卡信息(levelNum,maxScore,stars)
     *
     * @param dto 关卡信息
     * @return {@link Integer}
     */
    Integer updateLevel(HappyClearRecordDto dto);

    /**
     * 获取用户关卡信息
     * 实现方法内部，Redis缓存的是用户的全部记录，这里的查询在缓存失效时，还是会查询用户全部记录，如果可以明确指定查询用户某一个关卡的数据，不建议使用此方法！！！
     * 明确指定查询用户某一关卡记录{@link RemoteHappyClearRecordService#getByActCidLev}
     *
     * @param activityId 入库ID
     * @param consumerId 用户ID
     * @param levelNum   关卡
     * @return {@link List<HappyClearRecordDto>}
     */
    @Deprecated
    List<HappyClearRecordDto> getConsumerRecords(Long activityId, Long consumerId, Integer levelNum);

    /**
     * 批量获取用户关卡信息
     *
     * @param activityId  入库ID
     * @param consumerIds 用户ID集合
     * @param levelNum    关卡
     * @return {@link List<HappyClearRecordDto>}
     */
    List<HappyClearRecordDto> getRecordsByConsumerIdsAndLevelNum(Long activityId, List<Long> consumerIds, Integer levelNum);

    /**
     * 批量获取用户关卡信息
     * 因数据表过大，存在性能问题，且当前只在排行榜使用，而重构之后排行榜有单独的统计方式，故此该方法弃用！！！
     *
     * @param activityId  入库ID
     * @param consumerIds 用户ID集合
     * @return {@link List<HappyClearRecordDto>}
     */
    @Deprecated
    List<HappyClearRecordDto> getRecordsByConsumerIds(Long activityId, List<Long> consumerIds);


    /**
     * 获得排名列表
     *
     * @param activityId 入库ID
     * @return {@link List<HappyClearRecordDto>}
     */
    List<HappyClearRecordDto> getRankingList(Long activityId);

    /**
     * 分页获取用户关卡记录（sort by levelNum desc）
     * 放弃使用该方法，使用指定关卡范围的查询，减少SQL检索行{@link RemoteHappyClearRecordService#findByLevelRange(Long, Long, Long, Long)}
     *
     * @param param 参数
     * @return {@link List<HappyClearRecordDto>}
     */
    @Deprecated
    List<HappyClearRecordDto> findByActCid(HappyClearRecordQueryParam param);

    /**
     * 指定关卡范围获取用户闯关记录
     *
     * @param activityId 活动id
     * @param consumerId 用户id
     * @param lowerLevel 关卡下限（含）
     * @param upperLevel 关卡上限（含）
     * @return {@link List<HappyClearRecordDto>}
     */
    List<HappyClearRecordDto> findByLevelRange(Long activityId, Long consumerId, Long lowerLevel, Long upperLevel);

    /**
     * 查询用户闯关记录数
     *
     * @param activityId 活动id
     * @param consumerId 用户id
     * @return {@link Integer}
     */
    Integer countByActCid(Long activityId, Long consumerId);

    /**
     * 获取用户某一关卡信息
     *
     * @param activityId 入库ID
     * @param consumerId 用户ID
     * @param levelNum   关卡
     * @return {@link HappyClearRecordDto}
     */
    HappyClearRecordDto getByActCidLev(Long activityId, Long consumerId, Integer levelNum);
}
