package cn.com.duiba.activity.custom.center.api.remoteservice.zhongxin;

import cn.com.duiba.activity.custom.center.api.dto.zhongxin.ZhonxinVirtualCodeDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @description: 中信定制虚拟商品 券码
 * @author: lja
 * @date: Created on 2020/6/8 11:32
 * @version:
 */
@AdvancedFeignClient
public interface RemoteZhongxinVirtualCodeService {


    /**
     * 获取一张未使用的券码
     *
     * @param orderId 订单id
     * @param rickType  券的价值类型
     * @param actId  活动id
     * @return
     */
    ZhonxinVirtualCodeDto takeOneCode(Long orderId,Integer rickType, String actId);


    /**
     * 批量插入券码，默认 未使用状态
     * @param dtos 控制list数量，防止数据量过大超时，给数据库造成压力
     * @return int
     */
    int batchInsertVirtualCodes(List<ZhonxinVirtualCodeDto> dtos);

    /**
     * 取消使用券码
     * @param orderId
     * @return
     */
    boolean rollbackCode(Long orderId);


    /**
     * 标记券为已使用
     * @param orderId
     * @return
     */
    boolean finishCode(Long orderId);

}
