package cn.com.duiba.activity.custom.center.api.dto.reconciliation;

/**
 * @author zhengjianhao
 * @date 2020/2/20
 * @description
 */
public enum ReconciliationLogTypeEnum {
	ADD_CREDITS(1, "加积分"),
	SUB_CREDITS(2, "减积分"),
	MALL_EXCHANGE(3, "普兑"),
	;

	private int code;
	private String desc;

	ReconciliationLogTypeEnum(int code, String desc) {
		this.code = code;
		this.desc = desc;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public static ReconciliationLogTypeEnum getReconciliationLogTypeEnumByCode(int code) {
		ReconciliationLogTypeEnum[] tempEnums = ReconciliationLogTypeEnum.values();
		for (ReconciliationLogTypeEnum tempEnum : tempEnums) {
			if (code == tempEnum.getCode()) {
				return tempEnum;
			}
		}
		return null;
	}
}
