package cn.com.duiba.activity.custom.center.api.enums.cmbbank;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2019/5/27 0027 17:29
 */
public enum InterestStatusEnum {
    DEFAULT(0, "默认值"),
    CASH_OUT(1, "已提现"),
    /**
     * 数据库中无此状态，仅用于展示
     */
    CAN_OUT(2, "可提现"),
    /**
     * 当前时间小于利息结束时间，是计算中
     * 数据库中无此状态
     */
    CALING(3, "体验中"),

    /**
     * 因为需求修改，扩展字段
     */
    CASH_ING(4, "提现中"),
    CASH_OUT_FAIL(5, "提现失败"),
    /**
     * 没有利息是直接结束
     * 数据库中无此状态
     */
    END(6, "结束");

    private int code;
    private String desc;

    InterestStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
