package cn.com.duiba.activity.custom.center.api.remoteservice.annaier;

import cn.com.duiba.activity.custom.center.api.dto.annaier.AnrGroupUserRecordDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: lufeng
 * @Description: 安奈儿定制0元拼团接口
 * 技术文档：http://cf.dui88.com/pages/viewpage.action?pageId=22306587
 * 需求文档：http://cf.dui88.com/pages/viewpage.action?pageId=22302444
 * @Date: Created in 2019/6/10
 */
@AdvancedFeignClient
public interface RemoteAnrGroupUserService {

    /**
     * 新增用户参团表信息
     * @param entity
     * @return
     */
    Long insertAnrGroupUser(AnrGroupUserRecordDto entity) throws BizException;

    /**
     * 修改用户状态
     * @param groupRecordId
     * @param recordStatus
     * @return
     */
    boolean updateAnrGroupUserStatus(Long groupRecordId, Integer recordStatus) throws BizException;

    /**
     * 修改用户状态
     * @param id
     * @param groupStatus
     * @return
     */
    boolean updateAnrGroupUserStatusById(Long id, Integer groupStatus) throws BizException;

    /** 4
     * 通过团记录id获取同一个团下的用户信息
     * @param groupRecordId
     * @return
     */
    List<AnrGroupUserRecordDto> listAnrGroupUserByGroupRecordId(Long groupRecordId) throws BizException;

    /**
     * 领奖
     * @param id
     * @param receiveAddressId
     * @return
     */
    boolean takePrize(Long id, Long receiveAddressId) throws BizException;


    /**
     * 领奖
     * @param id
     * @param receiveAddressId
     *       receiveAddress
     * @return
     */
    boolean takePrizeWithAddress(Long id, Long receiveAddressId, String receiveAddress)throws BizException;

    /**
     * 统计团人数
     * @param groupRecordId    团信息主键
     * @param activityId  活动id
     * @return
     */
    Integer countGroupUserRecordByGroupRecordId(Long groupRecordId,Long activityId) throws BizException;

    /**
     * 统计用户参与团次数
     * @param consumerId
     * @param appId
     * @return
     */
    Integer countGroupUserRecordByAppAndConsumerId(Long consumerId,Long appId) throws BizException;

    /**
     * 查看用户参与团记录
     * @param consumerId
     * @param activityId
     * @return
     */
    List<AnrGroupUserRecordDto>  listGroupUserRecordByConsumerId(Long consumerId,Long activityId) throws BizException;

    /**
     * 查看用户参与团记录
     * @param consumerId
     * @param itemId
     * @param activityId
     * @return
     */
    List<AnrGroupUserRecordDto>  getGroupUserRecord(Long consumerId,Long itemId,Long activityId) throws BizException;


    /**
     * 批量通过团记录id获取同一个团下的用户信息
     * @param groupRecordIds
     * @return
     */
    List<AnrGroupUserRecordDto> listAnrGroupUserByGroupRecordIds(List<Long> groupRecordIds)throws BizException;

    /**
     * 更新用户拼团记录为拼团失败
     * @param groupUserRecordIds
     * @return
     */
    Integer updateAnrGroupUserStatusToFailByIds(List<Long> groupUserRecordIds);

    /**
     * 查询用户在团记录id下是否有记录
     * @param groupRecordId
     * @return
     */
    AnrGroupUserRecordDto getAnrGroupUserRecordByConsumerId(Long groupRecordId, Long consumerId) throws BizException;

    /**
     * 删除用户团记录
     * @param id
     * @return
     */
    Boolean deleteUserRecordById(Long id) throws BizException;

}
