package cn.com.duiba.activity.custom.center.api.remoteservice.atour;

import cn.com.duiba.activity.custom.center.api.dto.atour.AtourBattleRecordDto;
import cn.com.duiba.activity.custom.center.api.dto.atour.SearchRecordParamDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author linjianhui
 * @description 亚朵答题对战记录相关
 * @date 2019-01-09 10:42
 */
@AdvancedFeignClient
public interface RemoteAtourBattleRecordService {

    /**
     * 插入pk记录
     *
     * @param atourBattleRecordDto
     * @return  记录id
     */
    Long insertRecord(AtourBattleRecordDto atourBattleRecordDto);

    /**
     * 更改pk记录
     *
     * @param atourBattleRecordDto
     * @return
     */
    Integer updateRecord(AtourBattleRecordDto atourBattleRecordDto);

    /**
     * 根据id查询记录
     * @param id
     * @return
     */
    AtourBattleRecordDto findById(Long id);

    /**
     * 获取用户对战记录列表
     * @param searchRecordParamDto
     * @return
     */
    List<AtourBattleRecordDto> getBattleRecordList(SearchRecordParamDto searchRecordParamDto);

}
