package cn.com.duiba.activity.custom.center.api.remoteservice.ccb;

import cn.com.duiba.activity.custom.center.api.enums.ccb.HystrixCircuitStatusEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 建行业务熔断器目前给白名单业务使用
 * @author 歪大哥😁
 * @date 2020/3/17.
 */
@AdvancedFeignClient
public interface RemoteCcbBusinessHystrixService {

    /**
     * 获取当前熔断器状态
     * {@link HystrixCircuitStatusEnum#OPEN} 1-开启
     * {@link HystrixCircuitStatusEnum#CLOSED} 2-关闭
     * {@link HystrixCircuitStatusEnum#HALF_OPEN} 3-半开启
     * @return
     */
    int getCircuitStatus();

    /**
     * 记录错误次数
     */
    void errorCount();
}
