package cn.com.duiba.activity.custom.center.api.remoteservice.kugou;

import cn.com.duiba.activity.custom.center.api.dto.kugou.KuGouDunkRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/8/14 20:27
 * @description: 酷狗直播灌篮游戏定制-用户参与记录
 */
@AdvancedFeignClient
public interface RemoteKuGouDunkRecordService {

	/**
	 * 新增
	 */
	Long insert(KuGouDunkRecordDto entity);

	/**
	 * 更新分数和完成状态
	 */
	int updateScoreStatus(Long id, Long score);

	/**
	 * 根据记录id查询
	 */
	KuGouDunkRecordDto selectById(Long id);

	/**
	 * 获取用户在直播间的参与次数：包括处理中和处理成功的
	 */
	int countByRoomIdAndConsumerId(Long operatingActivityId, Long roomId, Long consumerId);

	/**
	 * 获取用户分数最高的5条记录
	 */
	List<KuGouDunkRecordDto> selectHighestFiveByConsumerId(Long operatingActivityId, Long consumerId);

	/**
	 * 根据用户id批量获取参与记录：如果不传roomId，则查询全平台
	 */
	List<KuGouDunkRecordDto> selectByConsumerIds(Long operatingActivityId, Long roomId, List<Long> consumerIds, Date startTime, Date endTime);
}
