package cn.com.duiba.activity.custom.center.api.remoteservice.topicpk;

import cn.com.duiba.activity.custom.center.api.dto.topicpk.TopicPkActivityDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/25 16:09
 */
@AdvancedFeignClient
public interface RemoteTopicPkActivityService {

    /**
     * 详情
     */
    TopicPkActivityDto detail(Long id) throws BizException;

    /**
     * 保存/更新活动
     * 在传入话题+更新活动的情况下，会删除没有传入的话题，即删除不在本次更新中出现的话题
     */
    Long save(TopicPkActivityDto dto) throws BizException;

    /**
     * 按时间获取在线的活动
     */
    List<TopicPkActivityDto> findByActivityTime(Long appId, Date date) throws BizException;

    /**
     * 获取在指定时间之后的最新活动
     */
    TopicPkActivityDto findLatestByActivityTime(Long appId, Date date) throws BizException;

    /**
     * 按活动时间判断是否重叠
     *
     * @param exclusiveId 排除的Id,避免更新时与自己比较
     * @param startTime
     * @param endTime
     */
    TopicPkActivityDto findActivityTimeCross(Long exclusiveId, Long appId, Date startTime, Date endTime) throws BizException;
}
