package cn.com.duiba.activity.custom.center.api.remoteservice.toyota;

import cn.com.duiba.activity.custom.center.api.dto.toyota.ToyotaDealerInfoDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhengjianhao
 * @date 2020/2/13
 * @description 广汽丰田打星球-省市经销商
 */
@AdvancedFeignClient
public interface RemoteToyotaDealerInfoService {

	/**
	 * 批量新增
	 */
	int batchInsert(List<ToyotaDealerInfoDto> entityList);

	/**
	 * 查询省份列表
	 */
	List<String> selectProvinceList();

	/**
	 * 根据省份查询城市列表
	 */
	List<String> selectCityByProvince(String province);

	/**
	 * 根据城市查询经销商列表
	 */
	List<String> selectDealerByCity(String city);
}
