package cn.com.duiba.activity.custom.center.api.remoteservice.zjnews;

import cn.com.duiba.activity.custom.center.api.dto.zjnews.ZjnewsYearParticipateDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by HePeng on 2018/12/27 14:02.
 * 浙江新闻年货节活动相关服务
 */
@AdvancedFeignClient
public interface RemoteZjnewsYearService {

    /**
     * 增加或更新用户参与图片记录
     * @param consumerId
     * @param picUrl
     * @return
     */
    ZjnewsYearParticipateDto addOrUpdatePicUrl(Long consumerId, String picUrl);

    /**
     * 用户参与了，更新状态
     * @param consumerId
     * @return
     */
    Boolean participate(Long consumerId);

    /**
     * 查询用户参与记录
     * @param consumerId
     * @return
     */
    ZjnewsYearParticipateDto findByConsumerId(Long consumerId);

    /**
     * 助力
     * @param consumerId
     * @param helperId
     * @return
     */
    Boolean help(Long consumerId, Long helperId) throws BizException;

    /**
     * 查询top list
     * @param cnt
     * @return
     */
    List<ZjnewsYearParticipateDto> findTopList(Integer cnt);

}
